import random
import string
from django.core.mail import send_mail
from django.http import HttpResponse
from django.shortcuts import render, redirect, get_object_or_404
from educaIAApp.models import Mensaje, Conversacion, Conocimiento, Prompting, User
from django.contrib.auth.decorators import login_required
from django.contrib.auth import logout
from openai import OpenAI
import os
import json

from educaIAProject import settings


# Create your views here.
def inicio(request):
    return render(request, 'educaIAApp/inicio.html')
def recuperacion(request):
    if request.method == 'POST':
        email = request.POST['email']
        username = request.POST['username']
        try:
            # Obtener el usuario por su nombre de usuario
            user = User.objects.get(username=username)

            # Comprobar que el email coincide
            if user.email == email:
                # Generar una nueva contraseña aleatoria
                new_password = ''.join(random.choices(string.ascii_letters + string.digits, k=8))

                # Actualizar la contraseña del usuario
                user.set_password(new_password)
                user.save()

                # Enviar la nueva contraseña por email
                subject = 'Cambio de contraseña'
                message = f'{username} tu nueva contraseña es: {new_password}'
                from_email = settings.EMAIL_HOST_USER
                recipient_list = [email]
                send_mail(subject, message, from_email, recipient_list)
                return redirect('Inicio')
        except User.DoesNotExist:
            return render(request, 'educaIAApp/recuperacion.html')
    return render(request, 'educaIAApp/recuperacion.html')


@login_required
def chat(request, conversacion_id=None):
    user = request.user
    conversaciones = Conversacion.objects.filter(usuario=user).order_by('fecha')
    # Si no se ha especificado una conversación, obtener la más reciente
    if conversacion_id is None and conversaciones.exists():
        conversacion = conversaciones.first()
    else:
        conversacion = get_object_or_404(Conversacion, id=conversacion_id) if conversacion_id else None
    messages = conversacion.mensajes.all() if conversacion else []
    conocimientos = conversacion.conocimientos.all() if conversacion else []
    promptings = conversacion.prompts.all() if conversacion else []
    if request.method == 'POST':
        config_path = os.path.join(settings.BASE_DIR, 'config.json')
        with open(config_path) as config_file:
            config = json.load(config_file)
        API_KEY = config.get('OPENAI_API_KEY')
        client = OpenAI(api_key=API_KEY)
        texto = request.POST.get('text', '')  # 'text' es el nombre del campo de entrada en tu formulario
        if texto:
            # Si no hay una conversación activa, crear una nueva
            if conversacion is None:
                conversacion = Conversacion.objects.create(usuario=user)
                mensaje_bienvenida = "Me llamo pepe"
                Mensaje.objects.create(conversacion=conversacion, sender='user', content=mensaje_bienvenida)
            elif not messages:  # Si la conversación existe pero no tiene mensajes
                # Enviar un mensaje porque la conversación existe pero está vacía
                mensaje_vacio = ("Introduce uno de los siguientes modos para practicar con ejemplos:\n-Diseño experimental\n"
                                 "-Diseño no experimental\n-Variables experimentales\n-Variables no experimentales\n"
                                 "-Muestreo probabilístico\n-Muestreo no probabilístico\n"
                                 "SE DEBE INTRODUCIR UNA DE LAS MODALIDADES ANTERIORESPARA QUE EL FUNCIONAMIENTO DE LA "
                                 "HERRAMIENTA SEA CORRECTO.")
                Mensaje.objects.create(conversacion=conversacion, sender='bot', content=mensaje_vacio)
                if any(phrase in texto for phrase in ['Diseños experimentales', 'diseños experimentales',
                                                      'Diseño experimental', 'diseño experimental']):
                    print('DISEÑO EXPERIMENTAL')
                    if user.grado == 'Pedagogía':
                        print('Pedagogía')
                        file_path2 = os.path.join(settings.BASE_DIR, 'educaIAApp', 'static', 'educaIAApp', 'prompting',
                                                  'diseños_exp2.txt')
                    else:
                        print('No pedagogía')
                        file_path2 = os.path.join(settings.BASE_DIR, 'educaIAApp', 'static', 'educaIAApp', 'prompting',
                                                  'diseños_exp.txt')

                    # Construir la ruta del archivo
                    file_path = os.path.join(settings.BASE_DIR, 'educaIAApp', 'static', 'educaIAApp', 'prompting',
                                         'prompting_diseños_exp.txt')

                    try:
                        with open(file_path2, 'r') as file:
                            definiciones = file.read()
                        Conocimiento.objects.create(conversacion=conversacion, conocimiento=definiciones)
                    except FileNotFoundError:
                        print(f"Archivo no encontrado: {file_path2}")
                    except Exception as e:
                        print(f"Error: {e}")
                    # Verificar y leer el archivo
                    try:
                        with open(file_path, 'r', encoding='utf-8') as file:
                            contenido = file.read()
                        Prompting.objects.create(conversacion=conversacion, prompt=contenido)
                    except FileNotFoundError:
                        print(f"Archivo no encontrado: {file_path}")
                    except Exception as e:
                        print(f"Error al leer el archivo: {e}")
                elif any(phrase in texto for phrase in ['Diseños no experimentales', 'diseños no experimentales',
                                                        'Diseño no experimental', 'diseño no experimental']):

                    print('DISEÑO NO EXPERIMENTAL')
                    file_path2 = os.path.join(settings.BASE_DIR, 'educaIAApp', 'static', 'educaIAApp', 'prompting',
                                              'diseños_noexp.txt')
                    # Construir la ruta del archivo
                    file_path = os.path.join(settings.BASE_DIR, 'educaIAApp', 'static', 'educaIAApp', 'prompting',
                                         'prompting_diseños_noexp.txt')

                    try:
                        with open(file_path2, 'r') as file:
                            definiciones = file.read()
                        Conocimiento.objects.create(conversacion=conversacion, conocimiento=definiciones)
                    except FileNotFoundError:
                        print(f"Archivo no encontrado: {file_path2}")
                    except Exception as e:
                        print(f"Error: {e}")
                    # Verificar y leer el archivo
                    try:
                        with open(file_path, 'r', encoding='utf-8') as file:
                            contenido = file.read()
                        Prompting.objects.create(conversacion=conversacion, prompt=contenido)
                    except FileNotFoundError:
                        print(f"Archivo no encontrado: {file_path}")
                    except Exception as e:
                        print(f"Error al leer el archivo: {e}")
                elif any(phrase in texto for phrase in ['Variables experimentales', 'variables experimentales',
                                                        'Variable experimental', 'variable experimental']):

                    print('VARIABLE EXPERIMENTAL')
                    file_path2 = os.path.join(settings.BASE_DIR, 'educaIAApp', 'static', 'educaIAApp', 'prompting',
                                              'variables_exp.txt')
                    # Construir la ruta del archivo
                    file_path = os.path.join(settings.BASE_DIR, 'educaIAApp', 'static', 'educaIAApp', 'prompting',
                                         'prompting_variables_exp.txt')

                    try:
                        with open(file_path2, 'r') as file:
                            definiciones = file.read()
                        Conocimiento.objects.create(conversacion=conversacion, conocimiento=definiciones)
                    except FileNotFoundError:
                        print(f"Archivo no encontrado: {file_path2}")
                    except Exception as e:
                        print(f"Error: {e}")
                    # Verificar y leer el archivo
                    try:
                        with open(file_path, 'r', encoding='utf-8') as file:
                            contenido = file.read()
                        Prompting.objects.create(conversacion=conversacion, prompt=contenido)
                    except FileNotFoundError:
                        print(f"Archivo no encontrado: {file_path}")
                    except Exception as e:
                        print(f"Error al leer el archivo: {e}")
                elif any(phrase in texto for phrase in ['Variables no experimentales', 'variables no experimentales',
                                                        'Variable no experimental', 'variable no experimental']):

                    print('VARIABLE NO EXPERIMENTAL')
                    file_path2 = os.path.join(settings.BASE_DIR, 'educaIAApp', 'static', 'educaIAApp', 'prompting',
                                              'variables_noexp.txt')
                    # Construir la ruta del archivo
                    file_path = os.path.join(settings.BASE_DIR, 'educaIAApp', 'static', 'educaIAApp', 'prompting',
                                         'prompting_variables_noexp.txt')

                    try:
                        with open(file_path2, 'r') as file:
                            definiciones = file.read()
                        Conocimiento.objects.create(conversacion=conversacion, conocimiento=definiciones)
                    except FileNotFoundError:
                        print(f"Archivo no encontrado: {file_path2}")
                    except Exception as e:
                        print(f"Error: {e}")
                    # Verificar y leer el archivo
                    try:
                        with open(file_path, 'r', encoding='utf-8') as file:
                            contenido = file.read()
                        Prompting.objects.create(conversacion=conversacion, prompt=contenido)
                    except FileNotFoundError:
                        print(f"Archivo no encontrado: {file_path}")
                    except Exception as e:
                        print(f"Error al leer el archivo: {e}")
                elif any(phrase in texto for phrase in ['Muestreos probabilísticos', 'muestreos probabilísticos',
                                                        'Muestreo probabilístico', 'muestreo probabilístico',
                                                        'Muestreos probabilisticos', 'muestreos probabilisticos',
                                                        'Muestreo probabilistico', 'muestreo probabilistico']):

                    print('MUESTREOS PROBABILÍSTICOS')
                    file_path2 = os.path.join(settings.BASE_DIR, 'educaIAApp', 'static', 'educaIAApp', 'prompting',
                                              'muestreo_prob.txt')
                    # Construir la ruta del archivo
                    file_path = os.path.join(settings.BASE_DIR, 'educaIAApp', 'static', 'educaIAApp', 'prompting',
                                         'prompting_muestreo_prob.txt')

                    try:
                        with open(file_path2, 'r') as file:
                            definiciones = file.read()
                        Conocimiento.objects.create(conversacion=conversacion, conocimiento=definiciones)
                    except FileNotFoundError:
                        print(f"Archivo no encontrado: {file_path2}")
                    except Exception as e:
                        print(f"Error: {e}")
                    # Verificar y leer el archivo
                    try:
                        with open(file_path, 'r', encoding='utf-8') as file:
                            contenido = file.read()
                        Prompting.objects.create(conversacion=conversacion, prompt=contenido)
                    except FileNotFoundError:
                        print(f"Archivo no encontrado: {file_path}")
                    except Exception as e:
                        print(f"Error al leer el archivo: {e}")
                elif any(phrase in texto for phrase in ['Muestreos no probabilísticos', 'muestreos no probabilísticos',
                                                        'Muestreo no probabilístico', 'muestreo no probabilístico',
                                                        'Muestreos no probabilisticos', 'muestreos no probabilisticos',
                                                        'Muestreo no probabilistico', 'muestreo no probabilistico']):

                    print('MUESTREOS NO PROBABILÍSTICOS')
                    file_path2 = os.path.join(settings.BASE_DIR, 'educaIAApp', 'static', 'educaIAApp', 'prompting',
                                              'muestreo_noprob.txt')
                    # Construir la ruta del archivo
                    file_path = os.path.join(settings.BASE_DIR, 'educaIAApp', 'static', 'educaIAApp', 'prompting',
                                         'prompting_muestreo_noprob.txt')

                    try:
                        with open(file_path2, 'r') as file:
                            definiciones = file.read()
                        Conocimiento.objects.create(conversacion=conversacion, conocimiento=definiciones)
                    except FileNotFoundError:
                        print(f"Archivo no encontrado: {file_path2}")
                    except Exception as e:
                        print(f"Error: {e}")
                    # Verificar y leer el archivo
                    try:
                        with open(file_path, 'r', encoding='utf-8') as file:
                            contenido = file.read()
                        Prompting.objects.create(conversacion=conversacion, prompt=contenido)
                    except FileNotFoundError:
                        print(f"Archivo no encontrado: {file_path}")
                    except Exception as e:
                        print(f"Error al leer el archivo: {e}")
                else:
                    Mensaje.objects.create(conversacion=conversacion, sender='user', content=texto)
                    Mensaje.objects.create(conversacion=conversacion, sender='bot', content="No has introducido un mensaje válido. Inicia una nueva conversación.")
                    return redirect('Chat', conversacion_id=conversacion.id)
            # Guarda el mensaje del usuario en la base de datos
            Mensaje.objects.create(conversacion=conversacion, sender='user', content=texto)
            #Mensaje.objects.create(usuario=user, sender='user', content=texto)
            #messages.append({"sender": "user", "content": texto})
            kb = [{"role": "user", "content": conocimiento.conocimiento}for conocimiento in conocimientos]
            pr = [{"role": "user", "content": prompting.prompt}for prompting in promptings]
            historial = [{"role": "user", "content": mensaje.content}if mensaje.sender == 'user'else
                         {"role": "assistant", "content": mensaje.content}for mensaje in messages]
            historial.append({"role": "user", "content": texto})
            all_messages = kb + pr + historial
            completion = client.chat.completions.create(
                model="gpt-3.5-turbo",  # Adjust the model as necessary
                messages=all_messages,
                temperature=0.3,  # menos temperatura, mas conservador. Mas temperatura, mas creativo
                # max_tokens=120  # Adjust based on expected length of translation
            )
            response = completion.choices[0].message.content
            Mensaje.objects.create(conversacion=conversacion, sender='bot', content=response)
            #Mensaje.objects.create(usuario=user, sender='bot', content=response)
            #messages.append(({"sender": "bot", "content": response}))
            return redirect('Chat', conversacion_id=conversacion.id)
    return render(request, 'educaIAApp/chat.html', {'messages': messages,
                                                    'conversaciones': conversaciones})

def nueva(request):
    nueva_conversacion = Conversacion.objects.create(usuario=request.user)

    # Crear un mensaje inicial para la nueva conversación
    #Mensaje.objects.create(conversacion=nueva_conversacion, sender='user')

    # Redirigir a la página de chat con la nueva conversación
    return redirect('Chat', conversacion_id=nueva_conversacion.id)
def cerrar_sesion(request):
    logout(request)
    return redirect('Inicio')

@login_required
def prompt(request):
    if request.user.rol != 'profesor':
        return redirect('Chat')
    static_dir = os.path.join(settings.BASE_DIR,'educaIAApp', 'static', 'educaIAApp', 'prompting')
    files = os.listdir(static_dir)
    files = [f for f in files if os.path.isfile(os.path.join(static_dir, f))]
    return render(request, 'educaIAApp/prompt.html', {'files': files})

@login_required
def edit(request, filename):
    if request.user.rol != 'profesor':
        return redirect('Chat')
    static_dir = os.path.join(settings.BASE_DIR,'educaIAApp', 'static', 'educaIAApp', 'prompting')
    file_path = os.path.join(static_dir, filename)

    if not os.path.exists(file_path):
        return HttpResponse('File not found', status=404)

    if request.method == 'POST':
        content = request.POST.get('content')
        content = content.replace('\r\n', '\n').replace('\r', '\n')
        with open(file_path, 'w', encoding='utf-8') as f:
            f.write(content)
        return redirect('Prompt')

    with open(file_path, 'r', encoding='utf-8') as f:
        content = f.read()

    return render(request, 'educaIAApp/edit.html', {'filename': filename, 'content': content})

def delete(request, conversacion_id):
    conversacion = get_object_or_404(Conversacion, id=conversacion_id)

    # Eliminar el objeto
    conversacion.delete()
    return redirect('Chat')

