from django.db import models
from users.models import User


# Create your models here.
#class User(AbstractUser):
#   grado = models.CharField(max_length=10)

class Conversacion(models.Model):
    usuario = models.ForeignKey(User, on_delete=models.CASCADE)
    fecha = models.DateTimeField(auto_now_add=True)

    def __str__(self):
        return f"Conversación del {self.fecha} de {self.usuario.username}"
class Mensaje(models.Model):
    conversacion = models.ForeignKey(Conversacion, on_delete=models.CASCADE, related_name='mensajes')
    sender = models.CharField(max_length=10)  # 'user' o 'bot'
    content = models.TextField()
    timestamp = models.DateTimeField(auto_now_add=True)

    def __str__(self):
        return f"{self.sender}: {self.content[:50]}"

class Conocimiento(models.Model):
    conversacion = models.ForeignKey(Conversacion, on_delete=models.CASCADE, related_name='conocimientos')
    conocimiento = models.CharField()
    def __str__(self):
        return f"{self.conocimiento}"

class Prompting(models.Model):
    conversacion = models.ForeignKey(Conversacion, on_delete=models.CASCADE, related_name='prompts')
    prompt = models.CharField()
    def __str__(self):
        return f"{self.prompt}"