from django.conf import settings
from django.contrib.auth import authenticate, login, update_session_auth_hash
from django.contrib.auth.tokens import default_token_generator
from django.contrib.auth.mixins import LoginRequiredMixin
from django.core.mail import send_mail
from django.shortcuts import render, redirect
from django.views import View
from .forms import ActualizarImagenPerfilForm
from django.contrib import messages
from .models import User


class RegistroView(View):
    def get(self, request):
        #form = CustomUserCreationForm()
        return render(request, "registro/registro.html")

    def post(self, request):
        email = request.POST.get('email')
        username = request.POST.get('username')
        password1 = request.POST.get('password')
        password2 = request.POST.get('password2')
        grado = request.POST.get('grado')
        if email and grado and username and password1 and password2:
            if password1 == password2:
                user = User(username=username, email=email, grado=grado)
                user.set_password(password1)
                verification_code = default_token_generator.make_token(user)
                request.session['user_data'] = {
                    'username': username,
                    'email': email,
                    'password': password1,
                    'grado': grado,
                    'codigo': verification_code,
                }
                subject = 'Verificación de correo electrónico'
                message = f'{username} tu código de verificación es: {verification_code}'
                from_email = settings.EMAIL_HOST_USER
                recipient_list = [email]
                send_mail(subject, message, from_email, recipient_list)
                # Crear usuario
                #usuario = User.objects.create_user(username=username, email=email, grado=grado, password=password1)
                #login(request, usuario)
                return redirect('Confirmacion')
            else:
                messages.error(request, "Las contraseñas no coinciden.")
        else:
            messages.error(request, "Por favor, completa todos los campos.")

        return redirect('Registro')

    '''
            FUNCIONA
            form = CustomUserCreationForm(request.POST)
            if form.is_valid():
                usuario = form.save()
                login(request, usuario)
                return redirect('Chat')
            else:
                return render(request, "registro/registro.html", {'form': form})
            '''

class ConfirmacionView(View):
    def get(self, request):
        return render(request, 'registro/confirmacion.html')
    def post(self, request):
        codigo = request.POST.get('codigo')
        print(codigo)
        if codigo:
            user_data = request.session.get('user_data')
            print(user_data['codigo'])
            if user_data:
                user = User.objects.create_user(username=user_data['username'],
                                                email=user_data['email'],
                                                grado=user_data['grado'],
                                                password=user_data['password'])
                if codigo == user_data['codigo']:
                    user.is_active = True
                    user.save()
                    del request.session['user_data']
                    login(request, user)
                    return redirect('Chat')
                else:
                    messages.error(request, "El código de confirmación no es válido")
            else:
                messages.error(request, "No se ha podido encontrar información asociada a este usuario")
        else:
            messages.error(request, "Por favor introduce un código")
        return redirect('Confirmacion')

class LoginView(View):
    def get(self, request):
        return render(request, 'login/login.html')
    def post(self, request):
        username = request.POST.get('username')
        password = request.POST.get('password')
        user = authenticate(request, username=username, password=password)
        if user is not None:
            login(request, user)
            return redirect('Chat')
        else:
            error_message = "Nombre de usuario o contraseña incorrectos."
            return redirect('Login')
class UsuariosView(LoginRequiredMixin, View):
    def get(self, request):
        form = ActualizarImagenPerfilForm(instance=request.user)
        return render(request, 'usuario.html', {'form': form})
        #return render(request, 'usuario.html')
    def post(self, request):
        form = ActualizarImagenPerfilForm(request.POST, request.FILES, instance=request.user)
        if form.is_valid():
            form.save()
            if request.FILES.get('imagen'):
                form.save()
                return redirect('Chat')
        nombre = request.POST.get('nombre')
        appellidos = request.POST.get('apellidos')
        password1 = request.POST.get('password1')
        password2 = request.POST.get('password2')
        password_updated = False
        if nombre:
            request.user.first_name = nombre
        if appellidos:
            request.user.last_name = appellidos
        if password1 and password2:
            if password1 == password2:
                request.user.set_password(password1)
                password_updated = True
        request.user.save()

        if password_updated:
            update_session_auth_hash(request, request.user)
        return redirect('Chat')
